<?php
function getRemoteFilesize($url, $formatSize = true, $useHead = true)
{
    if (false !== $useHead) {
        stream_context_set_default(array('http' => array('method' => 'HEAD')));
    }
    $head = array_change_key_case(get_headers($url, 1));
    // content-length of download (in bytes), read from Content-Length: field
    $clen = isset($head['content-length']) ? $head['content-length'] : 0;

    // cannot retrieve file size, return "-1"
    if (!$clen) {
        return -1;
    }

    if (!$formatSize) {
        return $clen; // return size in bytes
    }

    $size = $clen;
    switch ($clen) {
        case $clen < 1024:
            $size = $clen .' B'; break;
        case $clen < 1048576:
            $size = round($clen / 1024, 2) .' KiB'; break;
        case $clen < 1073741824:
            $size = round($clen / 1048576, 2) . ' MiB'; break;
        case $clen < 1099511627776:
            $size = round($clen / 1073741824, 2) . ' GiB'; break;
    }

    return $size; // return formatted size
}
if(isset($_FILES['file']['name'])){
   // file name
   $filename = $_FILES['file']['name'];

   // Location
   $location = 'upload/'.$filename;

   // file extension
   $file_extension = pathinfo($location, PATHINFO_EXTENSION);
   $file_extension = strtolower($file_extension);

   // Valid extensions
   $valid_ext = array("pdf","doc","docx","jpg","png","jpeg",'document','zip','rar','xls','xlsx','pdf','docx','pptx','ppt','pptm','audio','mp3','wav','video','mkv','mp4','vlc');

   $response = 0;
   if(in_array($file_extension,$valid_ext)){
      // Upload file
      if(move_uploaded_file($_FILES['file']['tmp_name'],$location)){
          switch($file_extension){
            case 'zip':
                $icon = 'fa fa-file-archive-o';
                break;
                case 'rar':
                $icon = 'fa fa-file-archive-o';
                break;
                case 'mp3':
                $icon = 'fa fa-file-audio-o';
                break;
                case 'xls':
                $icon = 'fa fa-file-excel-o';
                break;
                case 'xlsx':
                $icon = 'fa fa-file-excel-o';
                break;
                case 'png':
                $icon = 'fa fa-file-image-o';
                break;
                case 'jpg':
                $icon = 'fa fa-file-image-o';
                break;
                case 'svg':
                $icon = 'fa fa-file-image-o';
                break;
                case 'gif':
                $icon = 'fa fa-file-image-o';
                break;
                case 'jpeg':
                $icon = 'fa fa-file-image-o';
                break;
                case 'mp4':
                $icon = 'fa fa-file-movie-o';
                break;
                case 'mkv':
                $icon = 'fa fa-file-movie-o';
                break;
                case 'pdf':
                $icon = 'fa fa-file-pdf-o';
                break;
                case 'pptx':
                $icon = 'fa fa-file-powerpoint-o';
                break;
                case 'pptm':
                $icon = 'fa fa-file-powerpoint-o';
                break;
                case 'ppt':
                $icon = 'fa fa-file-powerpoint-o';
                break;
                case 'docx':
                $icon = 'fa fa-file-word-o';
                break;
                case 'dot':
                $icon = 'fa fa-file-word-o';
                break;
                case 'dotm':
                $icon = 'fa fa-file-word-o';
                break;
                default:
                    $icon = 'fa fa-file-o';
        }
               $json = array('status'=>'1', 'link'=>$location, 'type'=> $file_extension, 'name' => $filename, 'size' => getRemoteFilesize('https://app2.drsiamakheydari.ir/'.$location), 'icon'=>$icon);

      } 
   }

   print_r( json_encode($json));
   exit;
}